/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: Ecat_Structs.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    EtherCAT protocol structures

   Changes:

     Version    Date        Author   Description
     ----------------------------------------------------------------------------------
     21        22.02.2011  eo
        Usage of __PACKED_XXX defines replaced by __TLR_PACKED_XXX defines
        See issue #0012625: Ecat_Structs.h: Header uses __PACKED_XXX instead of __TLR_PACKED_XXX

     20        01.09.2008  sb
        added ECAT_AL_STATUS_CODE_CONFIGURATION_CLEARED

     18        26.08.2008  sb
        added ECAT_AL_STATUS_CODE_WARMSTART_REQUESTED
        added ECAT_AL_STATUS_CODE_CHANNEL_INIT_REQUESTED

     17        29.04.2008  sb
        added error code ECAT_AL_STATUS_CODE_FIRMWARE_IS_BOOTING

     16        14.12.2007  sb
        added new error code for Mbx InvalidSize

     15        23.03.2007  sb
        Updated source header

     13        19.03.2007  sb
        Corrected Mailbox Response structure added usMbxCommand field

      1        13.06.2005  SB       1.000
        Created

**************************************************************************************/
#ifndef __ECAT_STRUCTS_H
#define __ECAT_STRUCTS_H

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(ECAT_STRUCTS_PUBLIC)
#endif


#define ECAT_SYNCMAN_DEF_MBX_SIZE  128

/****************************************************************************************/

/* !!!!!!!!!! Currently little endian only !!!!!!!!!! */

/*
 * AL status code definitions
 */

#define ECAT_AL_STATUS_CODE_NO_ERROR  (0x0000)
#define ECAT_AL_STATUS_CODE_UNSPECIFIED_ERROR (0x0001)
#define ECAT_AL_STATUS_CODE_INVALID_REQUESTED_STATE_CHANGE (0x0011)
#define ECAT_AL_STATUS_CODE_UNKNOWN_REQUESTED_STATE (0x0012)
#define ECAT_AL_STATUS_CODE_BOOTSTRAP_NOT_SUPPORTED (0x0013)
#define ECAT_AL_STATUS_CODE_NO_VALID_FIRMWARE (0x0014)
#define ECAT_AL_STATUS_CODE_INVALID_MAILBOX_CONFIGURATION_BOOTSTRAP (0x0015)
#define ECAT_AL_STATUS_CODE_INVALID_MAILBOX_CONFIGURATION_PREOP (0x0016)
#define ECAT_AL_STATUS_CODE_INVALID_SYNC_MANAGER_CONFIGURATION (0x0017)
#define ECAT_AL_STATUS_CODE_NO_VALID_INPUTS_AVAILABLE (0x0018)
#define ECAT_AL_STATUS_CODE_NO_VALID_OUTPUTS (0x0019)
#define ECAT_AL_STATUS_CODE_SYNCHRONIZATION_ERROR (0x001A)
#define ECAT_AL_STATUS_CODE_SYNC_MANAGER_WATCHDOG (0x001B)
#define ECAT_AL_STATUS_CODE_INVALID_OUTPUT_CONFIGURATION (0x001D)
#define ECAT_AL_STATUS_CODE_INVALID_INPUT_CONFIGURATION (0x001E)
#define ECAT_AL_STATUS_CODE_SLAVE_NEEDS_COLD_START (0x0020)
#define ECAT_AL_STATUS_CODE_SLAVE_NEEDS_INIT (0x0021)
#define ECAT_AL_STATUS_CODE_SLAVE_NEEDS_PREOP (0x0022)
#define ECAT_AL_STATUS_CODE_SLAVE_NEEDS_SAFEOP (0x0023)

/* vendor specific al status codes */
#define ECAT_AL_STATUS_CODE_HOST_NOT_READY (0x8000)
#define ECAT_AL_STATUS_CODE_IO_DATA_SIZE_NOT_CONFIGURED (0x8001)
#define ECAT_AL_STATUS_CODE_DPM_HOST_WATCHDOG_TRIGGERED (0x8002)
#define ECAT_AL_STATUS_CODE_DC_CFG_INVALID (0x8003)
#define ECAT_AL_STATUS_CODE_FIRMWARE_IS_BOOTING (0x8004)
#define ECAT_AL_STATUS_CODE_WARMSTART_REQUESTED (0x8005)
#define ECAT_AL_STATUS_CODE_CHANNEL_INIT_REQUESTED (0x8006)
#define ECAT_AL_STATUS_CODE_CONFIGURATION_CLEARED (0x8007)

/*
 * ALEVENT register structure
 */

typedef __TLR_PACKED_PRE struct ECAT_ALEVENT_tag
{
  TLR_UINT8 fAlControlEvent : 1;
  TLR_UINT8 fLatchEvent : 1;
  TLR_UINT8 fSync0Event : 1;
  TLR_UINT8 fSync1Event : 1;
  TLR_UINT8 reserved1 : 4;
  TLR_UINT8 fSyncManChannel0Event : 1;
  TLR_UINT8 fSyncManChannel1Event : 1;
  TLR_UINT8 fSyncManChannel2Event : 1;
  TLR_UINT8 fSyncManChannel3Event : 1;
  TLR_UINT8 fSyncManChannel4Event : 1;
  TLR_UINT8 fSyncManChannel5Event : 1;
  TLR_UINT8 fSyncManChannel6Event : 1;
  TLR_UINT8 fSyncManChannel7Event : 1;
  TLR_UINT8 fSyncManChannel8Event : 1;
  TLR_UINT8 fSyncManChannel9Event : 1;
  TLR_UINT8 fSyncManChannel10Event : 1;
  TLR_UINT8 fSyncManChannel11Event : 1;
  TLR_UINT8 fSyncManChannel12Event : 1;
  TLR_UINT8 fSyncManChannel13Event : 1;
  TLR_UINT8 fSyncManChannel14Event : 1;
  TLR_UINT8 fSyncManChannel15Event : 1;
  TLR_UINT8 reserved2 : 8;
} __TLR_PACKED_POST ECAT_ALEVENT_T;
typedef struct ECAT_ALEVENT_tag ECAT_ALEVENTMASK_T;


/*
 * Sync Manager Unit Data structure
 */

typedef __TLR_PACKED_PRE struct ECAT_SYNCMAN_tag
{
  TLR_UINT16 usPhysicalStartAddress;
  TLR_UINT16 usLength;
  TLR_UINT8 uBufferType : 2;
  TLR_UINT8 uDirection : 2;
  TLR_UINT8 reserved1 : 1;
  TLR_UINT8 fAlEventEnable : 1;
  TLR_UINT8 fWatchdogEnable : 1;
  TLR_UINT8 reserved2 : 1;
  TLR_UINT8 fWriteEvent : 1;
  TLR_UINT8 fReadEvent : 1;
  TLR_UINT8 fWatchdogTrigger : 1;
  TLR_UINT8 nOneBufferState : 1;
  TLR_UINT8 nTriBufferState : 2;
  TLR_UINT8 reserved3 : 2;
  TLR_UINT8 fChannelEnable : 1;
  TLR_UINT8 reserved5 : 7;
  TLR_UINT8 reserved6 : 8;
} __TLR_PACKED_POST ECAT_SYNCMAN_T;

#define ECAT_SYNCMAN_BUFFERTYPE_BUFFERED (0x00)
#define ECAT_SYNCMAN_BUFFERTYPE_QUEUED (0x02)

#define ECAT_SYNCMAN_DIRECTION_READ (0x00)
#define ECAT_SYNCMAN_DIRECTION_WRITE (0x01)

#define ECAT_SYNCMAN_ONEBUFFERSTATE_READ (0x00)
#define ECAT_SYNCMAN_ONEBUFFERSTATE_WRITTEN (0x01)

#define ECAT_SYNCMAN_TRIBUFFERSTATE_FIRST (0x00)
#define ECAT_SYNCMAN_TRIBUFFERSTATE_SECOND (0x01)
#define ECAT_SYNCMAN_TRIBUFFERSTATE_THIRD (0x02)
#define ECAT_SYNCMAN_TRIBUFFERSTATE_LOCKED (0x03)


typedef __TLR_PACKED_PRE struct ECAT_MBXHEADER_tag
{
  TLR_UINT16  usLength;
  TLR_UINT16  usAddress;
  TLR_UINT8   uChannel : 6;
  TLR_UINT8   uPriority : 2;
  TLR_UINT8   uType : 4;
  TLR_UINT8   uSeqCnt : 3;
  TLR_UINT8   uReserved : 1;
} __TLR_PACKED_POST ECAT_MBXHEADER_T;

#define ECAT_MAX_MBX_SIZE (3200)      /* this is the maximum size the ECS stack has to support. it can be less depending on chip type */

#define ECAT_MBX_MAX_DATA_SIZE (ECAT_MAX_MBX_SIZE - sizeof(ECAT_MBXHEADER_T))

INLINE TLR_UINT16 Ecs_MbxGetMaxDataSize(TLR_UINT16 usMbxSize)
{
  return usMbxSize - sizeof(ECAT_MBXHEADER_T);
}

typedef __TLR_PACKED_PRE struct ECAT_MBX_tag
{
  TLR_UINT16  usLength;
  TLR_UINT16  usAddress;
  TLR_UINT8   uChannel : 6;
  TLR_UINT8   uPriority : 2;
  TLR_UINT8   uType : 4;
  TLR_UINT8   uSeqCnt : 3;
  TLR_UINT8   uReserved : 1;
  TLR_UINT8   bData[ECAT_MBX_MAX_DATA_SIZE];
} __TLR_PACKED_POST ECAT_MBX_T;

typedef __TLR_PACKED_PRE struct ECAT_MBXRESPONSE_DATA_Ttag {
  TLR_UINT16  usMbxCommand;
  TLR_UINT16  usErrorCode;
} __TLR_PACKED_POST ECAT_MBXRESPONSE_DATA_T;

#define ECAT_MBX_E_SYNTAX_ERROR (0x0001)
#define ECAT_MBX_E_UNSUPPORTED_PROTOCOL (0x0002)
#define ECAT_MBX_E_INVALID_CHANNEL (0x0003)
#define ECAT_MBX_E_SERVICE_NOT_SUPP (0x0004)
#define ECAT_MBX_E_INVALID_HEADER (0x0005)
#define ECAT_MBX_E_SIZE_TOO_SHORT (0x0006)
#define ECAT_MBX_E_NO_MORE_MEMORY (0x0007)
#define ECAT_MBX_E_INVALID_SIZE   (0x0008)

#define ECAT_MBX_PRIORITY_LOWEST  (0x00)
#define ECAT_MBX_PRIORITY_LOW     (0x01)
#define ECAT_MBX_PRIORITY_HIGH    (0x02)
#define ECAT_MBX_PRIORITY_HIGHEST (0x03)

typedef __TLR_PACKED_PRE struct ECAT_MBXRESPONSE_Ttag
{
  ECAT_MBXHEADER_T        tHead;
  ECAT_MBXRESPONSE_DATA_T tData;
} __TLR_PACKED_POST ECAT_MBXRESPONSE_T;

/* Mailbox Response */
#define ECAT_MBX_TYPE_RESPONSE (0x0)
/* ADS over EtherCAT (AoE) */
#define ECAT_MBX_TYPE_ADS_OVER_ETHERCAT (0x01)
/* Ethernet over EtherCAT (EoE) */
#define ECAT_MBX_TYPE_ETHERNET_OVER_ETHERCAT (0x02)
/* CANopen over EtherCAT (CoE) */
#define ECAT_MBX_TYPE_CANOPEN_OVER_ETHERCAT (0x03)
/* File Access over EtherCAT (FoE) */
#define ECAT_MBX_TYPE_FILE_ACCESS_OVER_ETHERCAT (0x04)
/* IEC-61491 over EtherCAT (SoE) */
#define ECAT_MBX_TYPE_SERVO_PROFILE_OVER_ETHERCAT (0x05)
/* Vendor specific profile over EtherCAT (VoE) */
#define ECAT_MBX_TYPE_VENDOR_PROFILE_OVER_ETHERCAT (0x0f)

/***************************************************************************************/
/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(ECAT_STRUCTS_PUBLIC)
#endif


#endif /* #ifndef __ECAT_STRUCTS_H */
